"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def attach(
    hub, ctx, directory_arn: str, policy_reference: Dict, object_reference: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Attaches a policy object to a regular object. An object can have a limited number of attached policies.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory where both objects reside. For more information, see arns.
        policy_reference(Dict): The reference that is associated with the policy object.
        object_reference(Dict): The reference that identifies the object to which the policy will be attached.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.policy.init.attach(
                ctx, directory_arn=value, policy_reference=value, object_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.policy.init.attach directory_arn=value, policy_reference=value, object_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="attach_policy",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "PolicyReference": policy_reference,
            "ObjectReference": object_reference,
        },
    )


async def detach(
    hub, ctx, directory_arn: str, policy_reference: Dict, object_reference: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Detaches a policy from an object.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory where both objects reside. For more information, see arns.
        policy_reference(Dict): Reference that identifies the policy object.
        object_reference(Dict): Reference that identifies the object whose policy object will be detached.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.policy.init.detach(
                ctx, directory_arn=value, policy_reference=value, object_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.policy.init.detach directory_arn=value, policy_reference=value, object_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="detach_policy",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "PolicyReference": policy_reference,
            "ObjectReference": object_reference,
        },
    )


async def lookup(
    hub,
    ctx,
    directory_arn: str,
    object_reference: Dict,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all policies from the root of the Directory to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the ObjectIdentifier for such objects. If policies are present, it returns ObjectIdentifier, policyId, and policyType. Paths that don't lead to the root from the target object are ignored. For more information, see Policies.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory. For more information, see arns.
        object_reference(Dict): Reference that identifies the object whose policies will be looked up.
        next_token(str, optional): The token to request the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of items to be retrieved in a single call. This is an approximate number. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.policy.init.lookup(
                ctx, directory_arn=value, object_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.policy.init.lookup directory_arn=value, object_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="lookup_policy",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "ObjectReference": object_reference,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
