"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    directory_arn: str,
    object_reference: Dict,
    next_token: str = None,
    max_results: int = None,
    consistency_level: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns policies attached to an object in pagination fashion.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory where objects reside. For more information, see arns.
        object_reference(Dict): Reference that identifies the object for which policies will be listed.
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum number of items to be retrieved in a single call. This is an approximate number. Defaults to None.
        consistency_level(str, optional): Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.object_.policy.list_all(
                ctx, directory_arn=value, object_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.object_.policy.list_all directory_arn=value, object_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_object_policies",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "ObjectReference": object_reference,
            "NextToken": next_token,
            "MaxResults": max_results,
            "ConsistencyLevel": consistency_level,
        },
    )
