"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, directory_arn: str, object_reference: Dict, consistency_level: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves metadata about an object.

    Args:
        directory_arn(str): The ARN of the directory being retrieved.
        object_reference(Dict): A reference to the object.
        consistency_level(str, optional): The consistency level at which to retrieve the object information. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.object_.information.get_all(
                ctx, directory_arn=value, object_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.object_.information.get_all directory_arn=value, object_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="get_object_information",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "ObjectReference": object_reference,
            "ConsistencyLevel": consistency_level,
        },
    )
