"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    directory_arn: str,
    object_reference: Dict,
    next_token: str = None,
    max_results: int = None,
    consistency_level: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a paginated list of child objects that are associated with a given object.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory where the object resides. For more information, see arns.
        object_reference(Dict): The reference that identifies the object for which child objects are being listed.
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum number of items to be retrieved in a single call. This is an approximate number. Defaults to None.
        consistency_level(str, optional): Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.object_.child.list(
                ctx, directory_arn=value, object_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.object_.child.list directory_arn=value, object_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_object_children",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "ObjectReference": object_reference,
            "NextToken": next_token,
            "MaxResults": max_results,
            "ConsistencyLevel": consistency_level,
        },
    )
