"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    directory_arn: str,
    object_reference: Dict,
    schema_facet: Dict,
    attribute_names: List,
    consistency_level: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves attributes within a facet that are associated with an object.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory where the object resides.
        object_reference(Dict): Reference that identifies the object whose attributes will be retrieved.
        consistency_level(str, optional): The consistency level at which to retrieve the attributes on an object. Defaults to None.
        schema_facet(Dict): Identifier for the facet whose attributes will be retrieved. See SchemaFacet for details.
        attribute_names(List): List of attribute names whose values will be retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.object_.attribute.get_all(
                ctx,
                directory_arn=value,
                object_reference=value,
                schema_facet=value,
                attribute_names=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.object_.attribute.get_all directory_arn=value, object_reference=value, schema_facet=value, attribute_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="get_object_attributes",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "ObjectReference": object_reference,
            "ConsistencyLevel": consistency_level,
            "SchemaFacet": schema_facet,
            "AttributeNames": attribute_names,
        },
    )


async def list_all(
    hub,
    ctx,
    directory_arn: str,
    object_reference: Dict,
    next_token: str = None,
    max_results: int = None,
    consistency_level: str = None,
    facet_filter: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all attributes that are associated with an object.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory where the object resides. For more information, see arns.
        object_reference(Dict): The reference that identifies the object whose attributes will be listed.
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum number of items to be retrieved in a single call. This is an approximate number. Defaults to None.
        consistency_level(str, optional): Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object. Defaults to None.
        facet_filter(Dict, optional): Used to filter the list of object attributes that are associated with a certain facet. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.object_.attribute.list_all(
                ctx, directory_arn=value, object_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.object_.attribute.list_all directory_arn=value, object_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_object_attributes",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "ObjectReference": object_reference,
            "NextToken": next_token,
            "MaxResults": max_results,
            "ConsistencyLevel": consistency_level,
            "FacetFilter": facet_filter,
        },
    )


async def update_multiple(
    hub, ctx, directory_arn: str, object_reference: Dict, attribute_updates: List
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a given object's attributes.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory where the object resides. For more information, see arns.
        object_reference(Dict): The reference that identifies the object.
        attribute_updates(List): The attributes update structure.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.object_.attribute.update_multiple(
                ctx, directory_arn=value, object_reference=value, attribute_updates=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.object_.attribute.update_multiple directory_arn=value, object_reference=value, attribute_updates=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="update_object_attributes",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "ObjectReference": object_reference,
            "AttributeUpdates": attribute_updates,
        },
    )
