"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    directory_arn: str,
    typed_link_specifier: Dict,
    attribute_names: List,
    consistency_level: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves attributes that are associated with a typed link.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory where the typed link resides. For more information, see arns or Typed Links.
        typed_link_specifier(Dict): Allows a typed link specifier to be accepted as input.
        attribute_names(List): A list of attribute names whose values will be retrieved.
        consistency_level(str, optional): The consistency level at which to retrieve the attributes on a typed link. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.link_attribute.get_all(
                ctx, directory_arn=value, typed_link_specifier=value, attribute_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.link_attribute.get_all directory_arn=value, typed_link_specifier=value, attribute_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="get_link_attributes",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "TypedLinkSpecifier": typed_link_specifier,
            "AttributeNames": attribute_names,
            "ConsistencyLevel": consistency_level,
        },
    )


async def update_multiple(
    hub, ctx, directory_arn: str, typed_link_specifier: Dict, attribute_updates: List
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s identity, as defined by its IdentityAttributeOrder.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory where the updated typed link resides. For more information, see arns or Typed Links.
        typed_link_specifier(Dict): Allows a typed link specifier to be accepted as input.
        attribute_updates(List): The attributes update structure.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.link_attribute.update_multiple(
                ctx, directory_arn=value, typed_link_specifier=value, attribute_updates=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.link_attribute.update_multiple directory_arn=value, typed_link_specifier=value, attribute_updates=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="update_link_attributes",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "TypedLinkSpecifier": typed_link_specifier,
            "AttributeUpdates": attribute_updates,
        },
    )
