"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def create(
    hub,
    ctx,
    directory_arn: str,
    ordered_indexed_attribute_list: List,
    is_unique: bool,
    parent_reference: Dict = None,
    link_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an index object. See Indexing and search for more information.

    Args:
        directory_arn(str): The ARN of the directory where the index should be created.
        ordered_indexed_attribute_list(List): Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
        is_unique(bool): Indicates whether the attribute that is being indexed has unique values or not.
        parent_reference(Dict, optional): A reference to the parent object that contains the index object. Defaults to None.
        link_name(str, optional): The name of the link between the parent object and the index object. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.index.create(
                ctx, directory_arn=value, ordered_indexed_attribute_list=value, is_unique=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.index.create directory_arn=value, ordered_indexed_attribute_list=value, is_unique=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="create_index",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "OrderedIndexedAttributeList": ordered_indexed_attribute_list,
            "IsUnique": is_unique,
            "ParentReference": parent_reference,
            "LinkName": link_name,
        },
    )


async def list_(
    hub,
    ctx,
    directory_arn: str,
    index_reference: Dict,
    ranges_on_indexed_values: List = None,
    max_results: int = None,
    next_token: str = None,
    consistency_level: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists objects attached to the specified index.

    Args:
        directory_arn(str): The ARN of the directory that the index exists in.
        ranges_on_indexed_values(List, optional): Specifies the ranges of indexed values that you want to query. Defaults to None.
        index_reference(Dict): The reference to the index to list.
        max_results(int, optional): The maximum number of objects in a single page to retrieve from the index during a request. For more information, see Amazon Cloud Directory Limits. Defaults to None.
        next_token(str, optional): The pagination token. Defaults to None.
        consistency_level(str, optional): The consistency level to execute the request at. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.index.list(
                ctx, directory_arn=value, index_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.index.list directory_arn=value, index_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_index",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "RangesOnIndexedValues": ranges_on_indexed_values,
            "IndexReference": index_reference,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ConsistencyLevel": consistency_level,
        },
    )
