"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    directory_arn: str,
    object_reference: Dict,
    filter_attribute_ranges: List = None,
    filter_typed_link: Dict = None,
    next_token: str = None,
    max_results: int = None,
    consistency_level: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a paginated list of all the incoming TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see Typed Links.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) of the directory where you want to list the typed links.
        object_reference(Dict): Reference that identifies the object whose attributes will be listed.
        filter_attribute_ranges(List, optional): Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range. Defaults to None.
        filter_typed_link(Dict, optional): Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls. Defaults to None.
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum number of results to retrieve. Defaults to None.
        consistency_level(str, optional): The consistency level to execute the request at. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.incoming_typed_link.list_all(
                ctx, directory_arn=value, object_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.incoming_typed_link.list_all directory_arn=value, object_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_incoming_typed_links",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "ObjectReference": object_reference,
            "FilterAttributeRanges": filter_attribute_ranges,
            "FilterTypedLink": filter_typed_link,
            "NextToken": next_token,
            "MaxResults": max_results,
            "ConsistencyLevel": consistency_level,
        },
    )
