"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def detach(
    hub, ctx, directory_arn: str, index_reference: Dict, target_reference: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Detaches the specified object from the specified index.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) of the directory the index and object exist in.
        index_reference(Dict): A reference to the index object.
        target_reference(Dict): A reference to the object being detached from the index.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.from_index.detach(
                ctx, directory_arn=value, index_reference=value, target_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.from_index.detach directory_arn=value, index_reference=value, target_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="detach_from_index",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "IndexReference": index_reference,
            "TargetReference": target_reference,
        },
    )
