"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "to_object"


async def add(
    hub,
    ctx,
    directory_arn: str,
    schema_facet: Dict,
    object_reference: Dict,
    object_attribute_list: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a new Facet to an object. An object can have more than one facet applied on it.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory where the object resides. For more information, see arns.
        schema_facet(Dict): Identifiers for the facet that you are adding to the object. See SchemaFacet for details.
        object_attribute_list(List, optional): Attributes on the facet that you are adding to the object. Defaults to None.
        object_reference(Dict): A reference to the object you are adding the specified facet to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.facet.to_object_.add(
                ctx, directory_arn=value, schema_facet=value, object_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.facet.to_object.add directory_arn=value, schema_facet=value, object_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="add_facet_to_object",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "SchemaFacet": schema_facet,
            "ObjectAttributeList": object_attribute_list,
            "ObjectReference": object_reference,
        },
    )
