"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    schema_arn: str,
    name: str,
    attributes: List = None,
    object_type: str = None,
    facet_style: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Facet in a schema. Facet creation is allowed only in development or applied schemas.

    Args:
        schema_arn(str): The schema ARN in which the new Facet will be created. For more information, see arns.
        name(str): The name of the Facet, which is unique for a given schema.
        attributes(List, optional): The attributes that are associated with the Facet. Defaults to None.
        object_type(str, optional): Specifies whether a given object created from this facet is of type node, leaf node, policy or index.   Node: Can have multiple children but one parent.     Leaf node: Cannot have children but can have multiple parents.     Policy: Allows you to store a policy document and policy type. For more information, see Policies.     Index: Can be created with the Index API.  . Defaults to None.
        facet_style(str, optional): There are two different styles that you can define on any given facet, Static and Dynamic. For static facets, all attributes must be defined in the schema. For dynamic facets, attributes can be defined during data plane operations. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.facet.init.create(
                ctx, schema_arn=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.facet.init.create schema_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="create_facet",
        op_kwargs={
            "SchemaArn": schema_arn,
            "Name": name,
            "Attributes": attributes,
            "ObjectType": object_type,
            "FacetStyle": facet_style,
        },
    )


async def delete(hub, ctx, schema_arn: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a given Facet. All attributes and Rules that are associated with the facet will be deleted. Only development schema facets are allowed deletion.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) that is associated with the Facet. For more information, see arns.
        name(str): The name of the facet to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.facet.init.delete(
                ctx, schema_arn=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.facet.init.delete schema_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="delete_facet",
        op_kwargs={"SchemaArn": schema_arn, "Name": name},
    )


async def get(hub, ctx, schema_arn: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets details of the Facet, such as facet name, attributes, Rules, or ObjectType. You can call this on all kinds of schema facets -- published, development, or applied.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) that is associated with the Facet. For more information, see arns.
        name(str): The name of the facet to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.facet.init.get(ctx, schema_arn=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.facet.init.get schema_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="get_facet",
        op_kwargs={"SchemaArn": schema_arn, "Name": name},
    )


async def update(
    hub,
    ctx,
    schema_arn: str,
    name: str,
    attribute_updates: List = None,
    object_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Does the following:   Adds new Attributes, Rules, or ObjectTypes.   Updates existing Attributes, Rules, or ObjectTypes.   Deletes existing Attributes, Rules, or ObjectTypes.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) that is associated with the Facet. For more information, see arns.
        name(str): The name of the facet.
        attribute_updates(List, optional): List of attributes that need to be updated in a given schema Facet. Each attribute is followed by AttributeAction, which specifies the type of update operation to perform. . Defaults to None.
        object_type(str, optional): The object type that is associated with the facet. See CreateFacetRequest$ObjectType for more details. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.facet.init.update(
                ctx, schema_arn=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.facet.init.update schema_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="update_facet",
        op_kwargs={
            "SchemaArn": schema_arn,
            "Name": name,
            "AttributeUpdates": attribute_updates,
            "ObjectType": object_type,
        },
    )
