"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "from_object"


async def remove(
    hub, ctx, directory_arn: str, schema_facet: Dict, object_reference: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified facet from the specified object.

    Args:
        directory_arn(str): The ARN of the directory in which the object resides.
        schema_facet(Dict): The facet to remove. See SchemaFacet for details.
        object_reference(Dict): A reference to the object to remove the facet from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.facet.from_object_.remove(
                ctx, directory_arn=value, schema_facet=value, object_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.facet.from_object.remove directory_arn=value, schema_facet=value, object_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="remove_facet_from_object",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "SchemaFacet": schema_facet,
            "ObjectReference": object_reference,
        },
    )
