"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    schema_arn: str,
    name: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves attributes attached to the facet.

    Args:
        schema_arn(str): The ARN of the schema where the facet resides.
        name(str): The name of the facet whose attributes will be retrieved.
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum number of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.facet.attribute.list_all(
                ctx, schema_arn=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.facet.attribute.list_all schema_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_facet_attributes",
        op_kwargs={
            "SchemaArn": schema_arn,
            "Name": name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
