"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, schema_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Directory by copying the published schema into the directory. A directory cannot be created without a schema. You can also quickly create a directory using a managed schema, called the QuickStartSchema. For more information, see Managed Schema in the Amazon Cloud Directory Developer Guide.

    Args:
        name(str): The name of the Directory. Should be unique per account, per region.
        schema_arn(str): The Amazon Resource Name (ARN) of the published schema that will be copied into the data Directory. For more information, see arns.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.directory.create(
                ctx, name=value, schema_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.directory.create name=value, schema_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="create_directory",
        op_kwargs={"Name": name, "SchemaArn": schema_arn},
    )


async def delete(hub, ctx, directory_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a directory. Only disabled directories can be deleted. A deleted directory cannot be undone. Exercise extreme caution when deleting directories.

    Args:
        directory_arn(str): The ARN of the directory to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.directory.delete(ctx, directory_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.directory.delete directory_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="delete_directory",
        op_kwargs={"DirectoryArn": directory_arn},
    )


async def disable(hub, ctx, directory_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables the specified directory. Disabled directories cannot be read or written to. Only enabled directories can be disabled. Disabled directories may be reenabled.

    Args:
        directory_arn(str): The ARN of the directory to disable.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.directory.disable(ctx, directory_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.directory.disable directory_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="disable_directory",
        op_kwargs={"DirectoryArn": directory_arn},
    )


async def enable(hub, ctx, directory_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Enables the specified directory. Only disabled directories can be enabled. Once enabled, the directory can then be read and written to.

    Args:
        directory_arn(str): The ARN of the directory to enable.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.directory.enable(ctx, directory_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.directory.enable directory_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="enable_directory",
        op_kwargs={"DirectoryArn": directory_arn},
    )


async def get(hub, ctx, directory_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves metadata about a directory.

    Args:
        directory_arn(str): The ARN of the directory.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.directory.get(ctx, directory_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.directory.get directory_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="get_directory",
        op_kwargs={"DirectoryArn": directory_arn},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, state: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists directories created within an account.

    Args:
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum number of results to retrieve. Defaults to None.
        state(str, optional): The state of the directories in the list. Can be either Enabled, Disabled, or Deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.directory.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.directory.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_directories",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results, "state": state},
    )
