"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves each Amazon Resource Name (ARN) of schemas in the development state.

    Args:
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum number of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.development_schema_arn.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.development_schema_arn.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_development_schema_arns",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
