"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    directory_arn: str,
    target_reference: Dict,
    next_token: str = None,
    max_results: int = None,
    consistency_level: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists indices attached to the specified object.

    Args:
        directory_arn(str): The ARN of the directory.
        target_reference(Dict): A reference to the object that has indices attached.
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum number of results to retrieve. Defaults to None.
        consistency_level(str, optional): The consistency level to use for this operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.attached_indice.list_all(
                ctx, directory_arn=value, target_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.attached_indice.list_all directory_arn=value, target_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_attached_indices",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "TargetReference": target_reference,
            "NextToken": next_token,
            "MaxResults": max_results,
            "ConsistencyLevel": consistency_level,
        },
    )
