"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, schema_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns current applied schema version ARN, including the minor version in use.

    Args:
        schema_arn(str): The ARN of the applied schema.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.applied_schema.version.get(ctx, schema_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.applied_schema.version.get schema_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="get_applied_schema_version",
        op_kwargs={"SchemaArn": schema_arn},
    )
