"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    directory_arn: str,
    schema_arn: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists schema major versions applied to a directory. If SchemaArn is provided, lists the minor version.

    Args:
        directory_arn(str): The ARN of the directory you are listing.
        schema_arn(str, optional): The response for ListAppliedSchemaArns when this parameter is used will list all minor version ARNs for a major version. Defaults to None.
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum number of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.applied_schema.arn.list_all(
                ctx, directory_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.applied_schema.arn.list_all directory_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_applied_schema_arns",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "SchemaArn": schema_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
