"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, environment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets status information for an Cloud9 development environment.

    Args:
        environment_id(str): The ID of the environment to get status information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloud9.environment.status.describe(ctx, environment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloud9.environment.status.describe environment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloud9",
        operation="describe_environment_status",
        op_kwargs={"environmentId": environment_id},
    )
