"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, environment_id: str, user_arn: str, permissions: str
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an environment member to an Cloud9 development environment.

    Args:
        environment_id(str): The ID of the environment that contains the environment member you want to add.
        user_arn(str): The Amazon Resource Name (ARN) of the environment member you want to add.
        permissions(str): The type of environment member permissions you want to associate with this environment member. Available values include:    read-only: Has read-only access to the environment.    read-write: Has read-write access to the environment.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloud9.environment.membership.create(
                ctx, environment_id=value, user_arn=value, permissions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloud9.environment.membership.create environment_id=value, user_arn=value, permissions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloud9",
        operation="create_environment_membership",
        op_kwargs={
            "environmentId": environment_id,
            "userArn": user_arn,
            "permissions": permissions,
        },
    )


async def delete(hub, ctx, environment_id: str, user_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an environment member from an Cloud9 development environment.

    Args:
        environment_id(str): The ID of the environment to delete the environment member from.
        user_arn(str): The Amazon Resource Name (ARN) of the environment member to delete from the environment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloud9.environment.membership.delete(
                ctx, environment_id=value, user_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloud9.environment.membership.delete environment_id=value, user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloud9",
        operation="delete_environment_membership",
        op_kwargs={"environmentId": environment_id, "userArn": user_arn},
    )


async def describe_all(
    hub,
    ctx,
    user_arn: str = None,
    environment_id: str = None,
    permissions: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about environment members for an Cloud9 development environment.

    Args:
        user_arn(str, optional): The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value is specified, information about all environment members are returned. Defaults to None.
        environment_id(str, optional): The ID of the environment to get environment member information about. Defaults to None.
        permissions(List, optional): The type of environment member permissions to get information about. Available values include:    owner: Owns the environment.    read-only: Has read-only access to the environment.    read-write: Has read-write access to the environment.   If no value is specified, information about all environment members are returned. Defaults to None.
        next_token(str, optional): During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a next token. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. Defaults to None.
        max_results(int, optional): The maximum number of environment members to get information about. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloud9.environment.membership.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloud9.environment.membership.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloud9",
        operation="describe_environment_memberships",
        op_kwargs={
            "userArn": user_arn,
            "environmentId": environment_id,
            "permissions": permissions,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub, ctx, environment_id: str, user_arn: str, permissions: str
) -> Dict:
    r"""
    **Autogenerated function**

    Changes the settings of an existing environment member for an Cloud9 development environment.

    Args:
        environment_id(str): The ID of the environment for the environment member whose settings you want to change.
        user_arn(str): The Amazon Resource Name (ARN) of the environment member whose settings you want to change.
        permissions(str): The replacement type of environment member permissions you want to associate with this environment member. Available values include:    read-only: Has read-only access to the environment.    read-write: Has read-write access to the environment.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloud9.environment.membership.update(
                ctx, environment_id=value, user_arn=value, permissions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloud9.environment.membership.update environment_id=value, user_arn=value, permissions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloud9",
        operation="update_environment_membership",
        op_kwargs={
            "environmentId": environment_id,
            "userArn": user_arn,
            "permissions": permissions,
        },
    )
