"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, environment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.

    Args:
        environment_id(str): The ID of the environment to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloud9.environment.init.delete(ctx, environment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloud9.environment.init.delete environment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloud9",
        operation="delete_environment",
        op_kwargs={"environmentId": environment_id},
    )


async def describe_all(hub, ctx, environment_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about Cloud9 development environments.

    Args:
        environment_ids(List): The IDs of individual environments to get information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloud9.environment.init.describe_all(ctx, environment_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloud9.environment.init.describe_all environment_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloud9",
        operation="describe_environments",
        op_kwargs={"environmentIds": environment_ids},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of Cloud9 development environment identifiers.

    Args:
        next_token(str, optional): During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along with a unique string called a next token. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. Defaults to None.
        max_results(int, optional): The maximum number of environments to get identifiers for. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloud9.environment.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloud9.environment.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloud9",
        operation="list_environments",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub, ctx, environment_id: str, name: str = None, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Changes the settings of an existing Cloud9 development environment.

    Args:
        environment_id(str): The ID of the environment to change settings.
        name(str, optional): A replacement name for the environment. Defaults to None.
        description(str, optional): Any new or replacement description for the environment. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloud9.environment.init.update(ctx, environment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloud9.environment.init.update environment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloud9",
        operation="update_environment",
        op_kwargs={
            "environmentId": environment_id,
            "name": name,
            "description": description,
        },
    )
