"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    instance_type: str,
    description: str = None,
    client_request_token: str = None,
    subnet_id: str = None,
    image_id: str = None,
    automatic_stop_time_minutes: int = None,
    owner_arn: str = None,
    tags: List = None,
    connection_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and then connects from the instance to the environment.

    Args:
        name(str): The name of the environment to create. This name is visible to other IAM users in the same Amazon Web Services account.
        description(str, optional): The description of the environment to create. Defaults to None.
        client_request_token(str, optional): A unique, case-sensitive string that helps Cloud9 to ensure this operation completes no more than one time. For more information, see Client Tokens in the Amazon EC2 API Reference. Defaults to None.
        instance_type(str): The type of instance to connect to the environment (for example, t2.micro).
        subnet_id(str, optional): The ID of the subnet in Amazon VPC that Cloud9 will use to communicate with the Amazon EC2 instance. Defaults to None.
        image_id(str, optional): The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. To choose an AMI for the instance, you must specify a valid AMI alias or a valid Amazon EC2 Systems Manager (SSM) path. The default AMI is used if the parameter isn't explicitly assigned a value in the request. Because Amazon Linux AMI has ended standard support as of December 31, 2020, we recommend you choose Amazon Linux 2, which includes long term support through 2023.  AMI aliases      Amazon Linux (default): amazonlinux-1-x86_64     Amazon Linux 2: amazonlinux-2-x86_64    Ubuntu 18.04: ubuntu-18.04-x86_64     SSM paths     Amazon Linux (default): resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64     Amazon Linux 2: resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64    Ubuntu 18.04: resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64   . Defaults to None.
        automatic_stop_time_minutes(int, optional): The number of minutes until the running instance is shut down after the environment has last been used. Defaults to None.
        owner_arn(str, optional): The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any IAM principal. If this value is not specified, the ARN defaults to this environment's creator. Defaults to None.
        tags(List, optional): An array of key-value pairs that will be associated with the new Cloud9 development environment. Defaults to None.
        connection_type(str, optional): The connection type used for connecting to an Amazon EC2 environment. Valid values are CONNECT_SSH (default) and CONNECT_SSM (connected through Amazon EC2 Systems Manager). For more information, see Accessing no-ingress EC2 instances with Amazon EC2 Systems Manager in the Cloud9 User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloud9.environment.ec2.create(
                ctx, name=value, instance_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloud9.environment.ec2.create name=value, instance_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloud9",
        operation="create_environment_ec2",
        op_kwargs={
            "name": name,
            "description": description,
            "clientRequestToken": client_request_token,
            "instanceType": instance_type,
            "subnetId": subnet_id,
            "imageId": image_id,
            "automaticStopTimeMinutes": automatic_stop_time_minutes,
            "ownerArn": owner_arn,
            "tags": tags,
            "connectionType": connection_type,
        },
    )
