"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, voice_connector_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the termination settings for the specified Amazon Chime Voice Connector.  If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the termination settings.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.termination.init.delete(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.termination.init.delete voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_voice_connector_termination",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def get(hub, ctx, voice_connector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves termination setting details for the specified Amazon Chime Voice Connector.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.termination.init.get(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.termination.init.get voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_voice_connector_termination",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def put(hub, ctx, voice_connector_id: str, termination: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds termination settings for the specified Amazon Chime Voice Connector.  If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off termination settings.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
        termination(Dict): The termination setting details to add.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.termination.init.put(
                ctx, voice_connector_id=value, termination=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.termination.init.put voice_connector_id=value, termination=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="put_voice_connector_termination",
        op_kwargs={"VoiceConnectorId": voice_connector_id, "Termination": termination},
    )
