"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(hub, ctx, voice_connector_id: str, usernames: List) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified SIP credentials used by your equipment to authenticate during call termination.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
        usernames(List): The RFC2617 compliant username associated with the SIP credentials, in US-ASCII format.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.termination.credential.delete_multiple(
                ctx, voice_connector_id=value, usernames=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.termination.credential.delete_multiple voice_connector_id=value, usernames=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_voice_connector_termination_credentials",
        op_kwargs={"VoiceConnectorId": voice_connector_id, "Usernames": usernames},
    )


async def list_all(hub, ctx, voice_connector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists the SIP credentials for the specified Amazon Chime Voice Connector.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.termination.credential.list_all(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.termination.credential.list_all voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_voice_connector_termination_credentials",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def put_multiple(
    hub, ctx, voice_connector_id: str, credentials: List = None
) -> None:
    r"""
    **Autogenerated function**

    Adds termination SIP credentials for the specified Amazon Chime Voice Connector.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
        credentials(List, optional): The termination SIP credentials. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.termination.credential.put_multiple(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.termination.credential.put_multiple voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="put_voice_connector_termination_credentials",
        op_kwargs={"VoiceConnectorId": voice_connector_id, "Credentials": credentials},
    )
