"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, voice_connector_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the streaming configuration for the specified Amazon Chime Voice Connector.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.streaming_configuration.delete(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.streaming_configuration.delete voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_voice_connector_streaming_configuration",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def get(hub, ctx, voice_connector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector. Shows whether media streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the Amazon Kinesis data.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.streaming_configuration.get(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.streaming_configuration.get voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_voice_connector_streaming_configuration",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def put(hub, ctx, voice_connector_id: str, streaming_configuration: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration specifies whether media streaming is enabled for sending to Indonesians. It also sets the retention period, in hours, for the Amazon Kinesis data.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
        streaming_configuration(Dict): The streaming configuration details to add.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.streaming_configuration.put(
                ctx, voice_connector_id=value, streaming_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.streaming_configuration.put voice_connector_id=value, streaming_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="put_voice_connector_streaming_configuration",
        op_kwargs={
            "VoiceConnectorId": voice_connector_id,
            "StreamingConfiguration": streaming_configuration,
        },
    )
