"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, voice_connector_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the proxy configuration from the specified Amazon Chime Voice Connector.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.proxy.delete(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.proxy.delete voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_voice_connector_proxy",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def get(hub, ctx, voice_connector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the proxy configuration details for the specified Amazon Chime Voice Connector.

    Args:
        voice_connector_id(str): The Amazon Chime voice connector ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.proxy.get(ctx, voice_connector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.proxy.get voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_voice_connector_proxy",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def put(
    hub,
    ctx,
    voice_connector_id: str,
    default_session_expiry_minutes: int,
    phone_number_pool_countries: List,
    fall_back_phone_number: str = None,
    disabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.

    Args:
        voice_connector_id(str): The Amazon Chime voice connector ID.
        default_session_expiry_minutes(int): The default number of minutes allowed for proxy sessions.
        phone_number_pool_countries(List): The countries for proxy phone numbers to be selected from.
        fall_back_phone_number(str, optional): The phone number to route calls to after a proxy session expires. Defaults to None.
        disabled(bool, optional): When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.proxy.put(
                ctx,
                voice_connector_id=value,
                default_session_expiry_minutes=value,
                phone_number_pool_countries=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.proxy.put voice_connector_id=value, default_session_expiry_minutes=value, phone_number_pool_countries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="put_voice_connector_proxy",
        op_kwargs={
            "VoiceConnectorId": voice_connector_id,
            "DefaultSessionExpiryMinutes": default_session_expiry_minutes,
            "PhoneNumberPoolCountries": phone_number_pool_countries,
            "FallBackPhoneNumber": fall_back_phone_number,
            "Disabled": disabled,
        },
    )
