"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, voice_connector_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the origination settings for the specified Amazon Chime Voice Connector.  If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the origination settings.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.origination.delete(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.origination.delete voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_voice_connector_origination",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def get(hub, ctx, voice_connector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves origination setting details for the specified Amazon Chime Voice Connector.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.origination.get(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.origination.get voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_voice_connector_origination",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def put(hub, ctx, voice_connector_id: str, origination: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds origination settings for the specified Amazon Chime Voice Connector.  If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off origination settings.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
        origination(Dict): The origination setting details to add.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.origination.put(
                ctx, voice_connector_id=value, origination=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.origination.put voice_connector_id=value, origination=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="put_voice_connector_origination",
        op_kwargs={"VoiceConnectorId": voice_connector_id, "Origination": origination},
    )
