"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, voice_connector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.logging_configuration.get(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.logging_configuration.get voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_voice_connector_logging_configuration",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def put(hub, ctx, voice_connector_id: str, logging_configuration: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
        logging_configuration(Dict): The logging configuration details to add.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.logging_configuration.put(
                ctx, voice_connector_id=value, logging_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.logging_configuration.put voice_connector_id=value, logging_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="put_voice_connector_logging_configuration",
        op_kwargs={
            "VoiceConnectorId": voice_connector_id,
            "LoggingConfiguration": logging_configuration,
        },
    )
