"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, name: str, voice_connector_items: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by including VoiceConnectorItems in the request. You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.

    Args:
        name(str): The name of the Amazon Chime Voice Connector group.
        voice_connector_items(List, optional): The Amazon Chime Voice Connectors to route inbound calls to. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.group.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.group.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_voice_connector_group",
        op_kwargs={"Name": name, "VoiceConnectorItems": voice_connector_items},
    )


async def delete(hub, ctx, voice_connector_group_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified Amazon Chime Voice Connector group. Any VoiceConnectorItems and phone numbers associated with the group must be removed before it can be deleted.

    Args:
        voice_connector_group_id(str): The Amazon Chime Voice Connector group ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.group.delete(
                ctx, voice_connector_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.group.delete voice_connector_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_voice_connector_group",
        op_kwargs={"VoiceConnectorGroupId": voice_connector_group_id},
    )


async def get(hub, ctx, voice_connector_group_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps,name, and associated VoiceConnectorItems.

    Args:
        voice_connector_group_id(str): The Amazon Chime Voice Connector group ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.group.get(
                ctx, voice_connector_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.group.get voice_connector_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_voice_connector_group",
        op_kwargs={"VoiceConnectorGroupId": voice_connector_group_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.

    Args:
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_voice_connector_groups",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub, ctx, voice_connector_group_id: str, name: str, voice_connector_items: List
) -> Dict:
    r"""
    **Autogenerated function**

    Updates details of the specified Amazon Chime Voice Connector group, such as the name and Amazon Chime Voice Connector priority ranking.

    Args:
        voice_connector_group_id(str): The Amazon Chime Voice Connector group ID.
        name(str): The name of the Amazon Chime Voice Connector group.
        voice_connector_items(List): The VoiceConnectorItems to associate with the group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.group.update(
                ctx, voice_connector_group_id=value, name=value, voice_connector_items=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.group.update voice_connector_group_id=value, name=value, voice_connector_items=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_voice_connector_group",
        op_kwargs={
            "VoiceConnectorGroupId": voice_connector_group_id,
            "Name": name,
            "VoiceConnectorItems": voice_connector_items,
        },
    )
