"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, voice_connector_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the emergency calling configuration details from the specified Amazon Chime Voice Connector.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.emergency_calling_configuration.delete(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.emergency_calling_configuration.delete voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_voice_connector_emergency_calling_configuration",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def get(hub, ctx, voice_connector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the emergency calling configuration details for the specified Amazon Chime Voice Connector.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.emergency_calling_configuration.get(
                ctx, voice_connector_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.emergency_calling_configuration.get voice_connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_voice_connector_emergency_calling_configuration",
        op_kwargs={"VoiceConnectorId": voice_connector_id},
    )


async def put(
    hub, ctx, voice_connector_id: str, emergency_calling_configuration: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Puts emergency calling configuration details to the specified Amazon Chime Voice Connector, such as emergency phone numbers and calling countries. Origination and termination settings must be enabled for the Amazon Chime Voice Connector before emergency calling can be configured.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
        emergency_calling_configuration(Dict): The emergency calling configuration details.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.voice_connector.emergency_calling_configuration.put(
                ctx, voice_connector_id=value, emergency_calling_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.voice_connector.emergency_calling_configuration.put voice_connector_id=value, emergency_calling_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="put_voice_connector_emergency_calling_configuration",
        op_kwargs={
            "VoiceConnectorId": voice_connector_id,
            "EmergencyCallingConfiguration": emergency_calling_configuration,
        },
    )
