"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, account_id: str, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves settings for the specified user ID, such as any associated phone number settings.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_id(str): The user ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.user.setting.get_all(ctx, account_id=value, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.user.setting.get_all account_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_user_settings",
        op_kwargs={"AccountId": account_id, "UserId": user_id},
    )


async def update_multiple(
    hub, ctx, account_id: str, user_id: str, user_settings: Dict
) -> None:
    r"""
    **Autogenerated function**

    Updates the settings for the specified user, such as phone number settings.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_id(str): The user ID.
        user_settings(Dict): The user settings to update.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.user.setting.update_multiple(
                ctx, account_id=value, user_id=value, user_settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.user.setting.update_multiple account_id=value, user_id=value, user_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_user_settings",
        op_kwargs={
            "AccountId": account_id,
            "UserId": user_id,
            "UserSettings": user_settings,
        },
    )
