"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    account_id: str,
    username: str = None,
    email: str = None,
    user_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a user under the specified Amazon Chime account.

    Args:
        account_id(str): The Amazon Chime account ID.
        username(str, optional): The user name. Defaults to None.
        email(str, optional): The user's email address. Defaults to None.
        user_type(str, optional): The user type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.user.init.create(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.user.init.create account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_user",
        op_kwargs={
            "AccountId": account_id,
            "Username": username,
            "Email": email,
            "UserType": user_type,
        },
    )


async def get(hub, ctx, account_id: str, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.  To retrieve user details with an email address instead of a user ID, use the ListUsers action, and then filter by email address.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_id(str): The user ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.user.init.get(ctx, account_id=value, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.user.init.get account_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_user",
        op_kwargs={"AccountId": account_id, "UserId": user_id},
    )


async def invite(
    hub, ctx, account_id: str, user_email_list: List, user_type: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime Team account. Only Team account types are currently supported for this action.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_email_list(List): The user email addresses to which to send the email invitation.
        user_type(str, optional): The user type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.user.init.invite(
                ctx, account_id=value, user_email_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.user.init.invite account_id=value, user_email_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="invite_users",
        op_kwargs={
            "AccountId": account_id,
            "UserEmailList": user_email_list,
            "UserType": user_type,
        },
    )


async def list_all(
    hub,
    ctx,
    account_id: str,
    user_email: str = None,
    user_type: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only the user that the email address belongs to.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_email(str, optional): Optional. The user email address used to filter results. Maximum 1. Defaults to None.
        user_type(str, optional): The user type. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to 100. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.user.init.list_all(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.user.init.list_all account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_users",
        op_kwargs={
            "AccountId": account_id,
            "UserEmail": user_email,
            "UserType": user_type,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def logout(hub, ctx, account_id: str, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Logs out the specified user from all of the devices they are currently logged into.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_id(str): The user ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.user.init.logout(ctx, account_id=value, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.user.init.logout account_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="logout_user",
        op_kwargs={"AccountId": account_id, "UserId": user_id},
    )


async def update(
    hub,
    ctx,
    account_id: str,
    user_id: str,
    license_type: str = None,
    user_type: str = None,
    alexa_for_business_metadata: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates user details for a specified user ID. Currently, only LicenseType updates are supported for this action.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_id(str): The user ID.
        license_type(str, optional): The user license type to update. This must be a supported license type for the Amazon Chime account that the user belongs to. Defaults to None.
        user_type(str, optional): The user type. Defaults to None.
        alexa_for_business_metadata(Dict, optional): The Alexa for Business metadata. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.user.init.update(ctx, account_id=value, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.user.init.update account_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_user",
        op_kwargs={
            "AccountId": account_id,
            "UserId": user_id,
            "LicenseType": license_type,
            "UserType": user_type,
            "AlexaForBusinessMetadata": alexa_for_business_metadata,
        },
    )
