"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, account_id: str, update_user_request_items: List) -> Dict:
    r"""
    **Autogenerated function**

    Updates user details within the UpdateUserRequestItem object for up to 20 users for the specified Amazon Chime account. Currently, only LicenseType updates are supported for this action.

    Args:
        account_id(str): The Amazon Chime account ID.
        update_user_request_items(List): The request containing the user IDs and details to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.update.user.batch(
                ctx, account_id=value, update_user_request_items=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.update.user.batch account_id=value, update_user_request_items=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="batch_update_user",
        op_kwargs={
            "AccountId": account_id,
            "UpdateUserRequestItems": update_user_request_items,
        },
    )
