"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, update_phone_number_request_items: List) -> Dict:
    r"""
    **Autogenerated function**

    Updates phone number product types or calling names. You can update one attribute at a time for each UpdatePhoneNumberRequestItem. For example, you can update the product type or the calling name. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type. Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.

    Args:
        update_phone_number_request_items(List): The request containing the phone number IDs and product types or calling names to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.update.phone_number.batch(
                ctx, update_phone_number_request_items=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.update.phone_number.batch update_phone_number_request_items=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="batch_update_phone_number",
        op_kwargs={"UpdatePhoneNumberRequestItems": update_phone_number_request_items},
    )
