"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, account_id: str, user_id_list: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime EnterpriseLWA account. Only users on EnterpriseLWA accounts can be unsuspended using this action. For more information about different account types, see  Managing Your Amazon Chime Accounts  in the account types, in the Amazon Chime Administration Guide.   Previously suspended users who are unsuspended using this action are returned to Registered status. Users who are not previously suspended are ignored.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_id_list(List): The request containing the user IDs to unsuspend.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.unsuspend_user.batch(
                ctx, account_id=value, user_id_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.unsuspend_user.batch account_id=value, user_id_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="batch_unsuspend_user",
        op_kwargs={"AccountId": account_id, "UserIdList": user_id_list},
    )
