"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, account_id: str, user_id_list: List) -> Dict:
    r"""
    **Autogenerated function**

    Suspends up to 50 users from a Team or EnterpriseLWA Amazon Chime account. For more information about different account types, see Managing Your Amazon Chime Accounts in the Amazon Chime Administration Guide. Users suspended from a Team account are disassociated from the account,but they can continue to use Amazon Chime as free users. To remove the suspension from suspended Team account users, invite them to the Team account again. You can use the InviteUsers action to do so. Users suspended from an EnterpriseLWA account are immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension from suspended EnterpriseLWA account users, use the BatchUnsuspendUser action.  To sign out users without suspending them, use the LogoutUser action.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_id_list(List): The request containing the user IDs to suspend.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.suspend_user.batch(
                ctx, account_id=value, user_id_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.suspend_user.batch account_id=value, user_id_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="batch_suspend_user",
        op_kwargs={"AccountId": account_id, "UserIdList": user_id_list},
    )
