"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, product_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists supported phone number countries.

    Args:
        product_type(str): The phone number product type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.supported_phone_number_country.list_all(
                ctx, product_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.supported_phone_number_country.list_all product_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_supported_phone_number_countries",
        op_kwargs={"ProductType": product_type},
    )
