"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    trigger_type: str,
    trigger_value: str,
    target_applications: List,
    disabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a SIP rule which can be used to run a SIP media application as a target for a specific trigger type.

    Args:
        name(str): The name of the SIP rule.
        trigger_type(str): The type of trigger assigned to the SIP rule in TriggerValue, currently RequestUriHostname or ToPhoneNumber.
        trigger_value(str): If TriggerType is RequestUriHostname, the value can be the outbound host name of an Amazon Chime Voice Connector. If TriggerType is ToPhoneNumber, the value can be a customer-owned phone number in the E164 format. The SipMediaApplication specified in the SipRule is triggered if the request URI in an incoming SIP request matches the RequestUriHostname, or if the To header in the incoming SIP request matches the ToPhoneNumber value.
        disabled(bool, optional): Enables or disables a rule. You must disable rules before you can delete them. Defaults to None.
        target_applications(List): List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.rule.create(
                ctx, name=value, trigger_type=value, trigger_value=value, target_applications=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.rule.create name=value, trigger_type=value, trigger_value=value, target_applications=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_sip_rule",
        op_kwargs={
            "Name": name,
            "TriggerType": trigger_type,
            "TriggerValue": trigger_value,
            "Disabled": disabled,
            "TargetApplications": target_applications,
        },
    )


async def delete(hub, ctx, sip_rule_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a SIP rule. You must disable a SIP rule before you can delete it.

    Args:
        sip_rule_id(str): The SIP rule ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.rule.delete(ctx, sip_rule_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.rule.delete sip_rule_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_sip_rule",
        op_kwargs={"SipRuleId": sip_rule_id},
    )


async def get(hub, ctx, sip_rule_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.

    Args:
        sip_rule_id(str): The SIP rule ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.rule.get(ctx, sip_rule_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.rule.get sip_rule_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_sip_rule",
        op_kwargs={"SipRuleId": sip_rule_id},
    )


async def list_all(
    hub,
    ctx,
    sip_media_application_id: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the SIP rules under the administrator's AWS account.

    Args:
        sip_media_application_id(str, optional): The SIP media application ID. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to 100. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.rule.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.rule.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_sip_rules",
        op_kwargs={
            "SipMediaApplicationId": sip_media_application_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    sip_rule_id: str,
    name: str,
    disabled: bool = None,
    target_applications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the details of the specified SIP rule.

    Args:
        sip_rule_id(str): The SIP rule ID.
        name(str): The new name for the specified SIP rule.
        disabled(bool, optional): The new value specified to indicate whether the rule is disabled. Defaults to None.
        target_applications(List, optional): The new value of the list of target applications. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.rule.update(ctx, sip_rule_id=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.rule.update sip_rule_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_sip_rule",
        op_kwargs={
            "SipRuleId": sip_rule_id,
            "Name": name,
            "Disabled": disabled,
            "TargetApplications": target_applications,
        },
    )
