"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, sip_media_application_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the logging configuration for the specified SIP media application.

    Args:
        sip_media_application_id(str): The SIP media application ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.media_application.logging_configuration.get(
                ctx, sip_media_application_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.media_application.logging_configuration.get sip_media_application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_sip_media_application_logging_configuration",
        op_kwargs={"SipMediaApplicationId": sip_media_application_id},
    )


async def put(
    hub,
    ctx,
    sip_media_application_id: str,
    sip_media_application_logging_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the logging configuration for the specified SIP media application.

    Args:
        sip_media_application_id(str): The SIP media application ID.
        sip_media_application_logging_configuration(Dict, optional): The actual logging configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.media_application.logging_configuration.put(
                ctx, sip_media_application_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.media_application.logging_configuration.put sip_media_application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="put_sip_media_application_logging_configuration",
        op_kwargs={
            "SipMediaApplicationId": sip_media_application_id,
            "SipMediaApplicationLoggingConfiguration": sip_media_application_logging_configuration,
        },
    )
