"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, aws_region: str, name: str, endpoints: List) -> Dict:
    r"""
    **Autogenerated function**

    Creates a SIP media application.

    Args:
        aws_region(str): The AWS Region assigned to the SIP media application.
        name(str): The SIP media application name.
        endpoints(List): List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.media_application.init.create(
                ctx, aws_region=value, name=value, endpoints=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.media_application.init.create aws_region=value, name=value, endpoints=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_sip_media_application",
        op_kwargs={"AwsRegion": aws_region, "Name": name, "Endpoints": endpoints},
    )


async def delete(hub, ctx, sip_media_application_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a SIP media application.

    Args:
        sip_media_application_id(str): The SIP media application ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.media_application.init.delete(
                ctx, sip_media_application_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.media_application.init.delete sip_media_application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_sip_media_application",
        op_kwargs={"SipMediaApplicationId": sip_media_application_id},
    )


async def get(hub, ctx, sip_media_application_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.

    Args:
        sip_media_application_id(str): The SIP media application ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.media_application.init.get(
                ctx, sip_media_application_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.media_application.init.get sip_media_application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_sip_media_application",
        op_kwargs={"SipMediaApplicationId": sip_media_application_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the SIP media applications under the administrator's AWS account.

    Args:
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to 100. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.media_application.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.media_application.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_sip_media_applications",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub, ctx, sip_media_application_id: str, name: str = None, endpoints: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the details of the specified SIP media application.

    Args:
        sip_media_application_id(str): The SIP media application ID.
        name(str, optional): The new name for the specified SIP media application. Defaults to None.
        endpoints(List, optional): The new set of endpoints for the specified SIP media application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.media_application.init.update(
                ctx, sip_media_application_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.media_application.init.update sip_media_application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_sip_media_application",
        op_kwargs={
            "SipMediaApplicationId": sip_media_application_id,
            "Name": name,
            "Endpoints": endpoints,
        },
    )
