"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    from_phone_number: str,
    to_phone_number: str,
    sip_media_application_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the endpoint of the specified sipMediaApplicationId.

    Args:
        from_phone_number(str): The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.
        to_phone_number(str): The phone number that the service should call.
        sip_media_application_id(str): The ID of the SIP media application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.media_application.call.create(
                ctx, from_phone_number=value, to_phone_number=value, sip_media_application_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.media_application.call.create from_phone_number=value, to_phone_number=value, sip_media_application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_sip_media_application_call",
        op_kwargs={
            "FromPhoneNumber": from_phone_number,
            "ToPhoneNumber": to_phone_number,
            "SipMediaApplicationId": sip_media_application_id,
        },
    )


async def update(
    hub, ctx, sip_media_application_id: str, transaction_id: str, arguments: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Allows you to trigger a Lambda function at any time while a call is active, and replace the current actions with new actions returned by the invocation.

    Args:
        sip_media_application_id(str): The ID of the SIP media application handling the call.
        transaction_id(str): The ID of the call transaction.
        arguments(Dict): Arguments made available to the Lambda function as part of the CALL_UPDATE_REQUESTED event. Can contain 0-20 key-value pairs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.sip.media_application.call.update(
                ctx, sip_media_application_id=value, transaction_id=value, arguments=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.sip.media_application.call.update sip_media_application_id=value, transaction_id=value, arguments=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_sip_media_application_call",
        op_kwargs={
            "SipMediaApplicationId": sip_media_application_id,
            "TransactionId": transaction_id,
            "Arguments": arguments,
        },
    )
