"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def disassociate(hub, ctx, account_id: str, group_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.

    Args:
        account_id(str): The Amazon Chime account ID.
        group_names(List): The sign-in delegate group names.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.signin_delegate_group.from_account.disassociate(
                ctx, account_id=value, group_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.signin_delegate_group.from_account.disassociate account_id=value, group_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="disassociate_signin_delegate_groups_from_account",
        op_kwargs={"AccountId": account_id, "GroupNames": group_names},
    )
