"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def regenerate(hub, ctx, account_id: str, bot_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Regenerates the security token for a bot.

    Args:
        account_id(str): The Amazon Chime account ID.
        bot_id(str): The bot ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.security_token.regenerate(
                ctx, account_id=value, bot_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.security_token.regenerate account_id=value, bot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="regenerate_security_token",
        op_kwargs={"AccountId": account_id, "BotId": bot_id},
    )
