"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def redact(hub, ctx, account_id: str, room_id: str, message_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Redacts the specified message from the specified Amazon Chime channel.

    Args:
        account_id(str): The Amazon Chime account ID.
        room_id(str): The room ID.
        message_id(str): The message ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.room.message.redact(
                ctx, account_id=value, room_id=value, message_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.room.message.redact account_id=value, room_id=value, message_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="redact_room_message",
        op_kwargs={"AccountId": account_id, "RoomId": room_id, "MessageId": message_id},
    )
