"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, account_id: str, room_id: str, member_id: str, role: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.

    Args:
        account_id(str): The Amazon Chime account ID.
        room_id(str): The room ID.
        member_id(str): The Amazon Chime member ID (user ID or bot ID).
        role(str, optional): The role of the member. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.room.membership.create(
                ctx, account_id=value, room_id=value, member_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.room.membership.create account_id=value, room_id=value, member_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_room_membership",
        op_kwargs={
            "AccountId": account_id,
            "RoomId": room_id,
            "MemberId": member_id,
            "Role": role,
        },
    )


async def delete(hub, ctx, account_id: str, room_id: str, member_id: str) -> None:
    r"""
    **Autogenerated function**

    Removes a member from a chat room in an Amazon Chime Enterprise account.

    Args:
        account_id(str): The Amazon Chime account ID.
        room_id(str): The room ID.
        member_id(str): The member ID (user ID or bot ID).
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.room.membership.delete(
                ctx, account_id=value, room_id=value, member_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.room.membership.delete account_id=value, room_id=value, member_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_room_membership",
        op_kwargs={"AccountId": account_id, "RoomId": room_id, "MemberId": member_id},
    )


async def list_all(
    hub,
    ctx,
    account_id: str,
    room_id: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members' IDs, email addresses, and names.

    Args:
        account_id(str): The Amazon Chime account ID.
        room_id(str): The room ID.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.room.membership.list_all(
                ctx, account_id=value, room_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.room.membership.list_all account_id=value, room_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_room_memberships",
        op_kwargs={
            "AccountId": account_id,
            "RoomId": room_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub, ctx, account_id: str, room_id: str, member_id: str, role: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates room membership details, such as the member role, for a room in an Amazon Chime Enterprise account. The member role designates whether the member is a chat room administrator or a general chat room member. The member role can be updated only for user IDs.

    Args:
        account_id(str): The Amazon Chime account ID.
        room_id(str): The room ID.
        member_id(str): The member ID.
        role(str, optional): The role of the member. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.room.membership.update(
                ctx, account_id=value, room_id=value, member_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.room.membership.update account_id=value, room_id=value, member_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_room_membership",
        op_kwargs={
            "AccountId": account_id,
            "RoomId": room_id,
            "MemberId": member_id,
            "Role": role,
        },
    )
