"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, account_id: str, name: str, client_request_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a chat room for the specified Amazon Chime Enterprise account.

    Args:
        account_id(str): The Amazon Chime account ID.
        name(str): The room name.
        client_request_token(str, optional): The idempotency token for the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.room.init.create(ctx, account_id=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.room.init.create account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_room",
        op_kwargs={
            "AccountId": account_id,
            "Name": name,
            "ClientRequestToken": client_request_token,
        },
    )


async def delete(hub, ctx, account_id: str, room_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a chat room in an Amazon Chime Enterprise account.

    Args:
        account_id(str): The Amazon Chime account ID.
        room_id(str): The chat room ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.room.init.delete(ctx, account_id=value, room_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.room.init.delete account_id=value, room_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_room",
        op_kwargs={"AccountId": account_id, "RoomId": room_id},
    )


async def get(hub, ctx, account_id: str, room_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.

    Args:
        account_id(str): The Amazon Chime account ID.
        room_id(str): The room ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.room.init.get(ctx, account_id=value, room_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.room.init.get account_id=value, room_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_room",
        op_kwargs={"AccountId": account_id, "RoomId": room_id},
    )


async def list_all(
    hub,
    ctx,
    account_id: str,
    member_id: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.

    Args:
        account_id(str): The Amazon Chime account ID.
        member_id(str, optional): The member ID (user ID or bot ID). Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.room.init.list_all(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.room.init.list_all account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_rooms",
        op_kwargs={
            "AccountId": account_id,
            "MemberId": member_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(hub, ctx, account_id: str, room_id: str, name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.

    Args:
        account_id(str): The Amazon Chime account ID.
        room_id(str): The room ID.
        name(str, optional): The room name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.room.init.update(ctx, account_id=value, room_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.room.init.update account_id=value, room_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_room",
        op_kwargs={"AccountId": account_id, "RoomId": room_id, "Name": name},
    )
