"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Applies the specified tags to the specified Amazon Chime SDK meeting resource.

    Args:
        resource_arn(str): The resource ARN.
        tags(List): The tag key-value pairs.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.resource.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="tag_resource",
        op_kwargs={"ResourceARN": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Untags the specified tags from the specified Amazon Chime SDK meeting resource.

    Args:
        resource_arn(str): The resource ARN.
        tag_keys(List): The tag keys.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.resource.untag(ctx, resource_arn=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="untag_resource",
        op_kwargs={"ResourceARN": resource_arn, "TagKeys": tag_keys},
    )
