"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    voice_connector_group_id: str,
    e164_phone_numbers: List,
    force_associate: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates phone numbers with the specified Amazon Chime Voice Connector group.

    Args:
        voice_connector_group_id(str): The Amazon Chime Voice Connector group ID.
        e164_phone_numbers(List): List of phone numbers, in E.164 format.
        force_associate(bool, optional): If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector Group and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.with_.voice_connector.group.associate(
                ctx, voice_connector_group_id=value, e164_phone_numbers=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.with_.voice_connector.group.associate voice_connector_group_id=value, e164_phone_numbers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="associate_phone_numbers_with_voice_connector_group",
        op_kwargs={
            "VoiceConnectorGroupId": voice_connector_group_id,
            "E164PhoneNumbers": e164_phone_numbers,
            "ForceAssociate": force_associate,
        },
    )
