"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub, ctx, account_id: str, user_id: str, e164_phone_number: str
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a phone number with the specified Amazon Chime user.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_id(str): The user ID.
        e164_phone_number(str): The phone number, in E.164 format.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.with_.user.associate(
                ctx, account_id=value, user_id=value, e164_phone_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.with_.user.associate account_id=value, user_id=value, e164_phone_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="associate_phone_number_with_user",
        op_kwargs={
            "AccountId": account_id,
            "UserId": user_id,
            "E164PhoneNumber": e164_phone_number,
        },
    )
