"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.setting.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.setting.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="chime", operation="get_phone_number_settings", op_kwargs={}
    )


async def update_multiple(hub, ctx, calling_name: str) -> None:
    r"""
    **Autogenerated function**

    Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name. You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72 hours to update.

    Args:
        calling_name(str): The default outbound calling name for the account.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.setting.update_multiple(
                ctx, calling_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.setting.update_multiple calling_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_phone_number_settings",
        op_kwargs={"CallingName": calling_name},
    )
